/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.hud;

import com.google.common.annotations.VisibleForTesting;

public final class ColorUtil {
    public static int interpolate(int colorStart, int colorEnd, float offset) {
        if (offset < 0.0f || offset > 1.0f) {
            throw new IllegalArgumentException("Offset must be between 0.0 and 1.0");
        }
        int redDiff = ColorUtil.getRed(colorEnd) - ColorUtil.getRed(colorStart);
        int greenDiff = ColorUtil.getGreen(colorEnd) - ColorUtil.getGreen(colorStart);
        int blueDiff = ColorUtil.getBlue(colorEnd) - ColorUtil.getBlue(colorStart);
        int newRed = Math.round((float)ColorUtil.getRed(colorStart) + (float)redDiff * offset);
        int newGreen = Math.round((float)ColorUtil.getGreen(colorStart) + (float)greenDiff * offset);
        int newBlue = Math.round((float)ColorUtil.getBlue(colorStart) + (float)blueDiff * offset);
        return newRed << 16 | newGreen << 8 | newBlue;
    }

    @VisibleForTesting
    static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    @VisibleForTesting
    static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    @VisibleForTesting
    static int getBlue(int color) {
        return color & 0xFF;
    }

    private ColorUtil() {
    }
}

